.include <src.opts.mk>

BINDIR?=	/usr/sbin

WARNS?=		0

WPA_DISTDIR?= 		${SRCTOP}/contrib/wpa
WPA_SUPPLICANT_DISTDIR?=${WPA_DISTDIR}/wpa_supplicant
HOSTAPD_DISTDIR?=	${WPA_DISTDIR}/hostapd

.PATH.c:${.CURDIR:H}

CFLAGS+=-I${.CURDIR}
CFLAGS+=-I${HOSTAPD_DISTDIR}
CFLAGS+=-I${WPA_DISTDIR}/src
CFLAGS+=-I${WPA_DISTDIR}/src/ap
CFLAGS+=-I${WPA_DISTDIR}/src/common
CFLAGS+=-I${WPA_DISTDIR}/src/crypto
CFLAGS+=-I${WPA_DISTDIR}/src/drivers
CFLAGS+=-I${WPA_DISTDIR}/src/eap_common
CFLAGS+=-I${WPA_DISTDIR}/src/eap_peer
CFLAGS+=-I${WPA_DISTDIR}/src/eap_server
CFLAGS+=-I${WPA_DISTDIR}/src/eapol_auth
CFLAGS+=-I${WPA_DISTDIR}/src/eapol_supp
CFLAGS+=-I${WPA_DISTDIR}/src/l2_packet
CFLAGS+=-I${WPA_DISTDIR}/src/radius
CFLAGS+=-I${WPA_DISTDIR}/src/rsn_supp
CFLAGS+=-I${WPA_DISTDIR}/src/tls
CFLAGS+=-I${WPA_DISTDIR}/src/utils
CFLAGS+=-I${WPA_DISTDIR}/src/wps

CFLAGS+=-DCONFIG_DRIVER_BSD
CFLAGS+=-DCONFIG_DRIVER_WIRED
CFLAGS+=-DCONFIG_DRIVER_RADIUS_ACL
CFLAGS+=-DCONFIG_CTRL_IFACE
CFLAGS+=-DCONFIG_CTRL_IFACE_UNIX
CFLAGS+=-DCONFIG_IEEE80211AC
CFLAGS+=-DCONFIG_IEEE80211N
CFLAGS+=-DCONFIG_IEEE80211R
CFLAGS+=-DCONFIG_IEEE80211W
CFLAGS+=-DTLS_DEFAULT_CIPHERS=\"DEFAULT:!EXP:!LOW\"
CFLAGS+=-DCONFIG_DEBUG_SYSLOG
CFLAGS+=-DPKCS12_FUNCS
CFLAGS+=-DCONFIG_GAS
CFLAGS+=-DCONFIG_PEERKEY
CFLAGS+=-DCONFIG_PRIVSEP
CFLAGS+=-DCONFIG_SMARTCARD
CFLAGS+=-DCONFIG_TDLS
CFLAGS+=-DCONFIG_TERMINATE_ONLASTIF
CFLAGS+=-DCONFIG_TLS=openssl
CFLAGS+=-DCONFIG_MATCH_IFACE
CFLAGS+=-DCONFIG_PTKSA_CACHE
CFLAGS+=-DEAP_SERVER
CFLAGS+=-DEAP_SERVER_GTC
CFLAGS+=-DEAP_SERVER_IDENTITY
CFLAGS+=-DEAP_SERVER_MD5
CFLAGS+=-DEAP_SERVER_MSCHAPV2
CFLAGS+=-DEAP_SERVER_PEAP
CFLAGS+=-DEAP_SERVER_TLS
CFLAGS+=-DEAP_SERVER_TTLS
CFLAGS+=-DEAP_SERVER_WSC
CFLAGS+=-DEAP_TLS_FUNCS
CFLAGS+=-DCONFIG_WNM
CFLAGS+=-DCONFIG_MBO
CFLAGS+=-DCONFIG_RSN_PREAUTH
CFLAGS+=-DCONFIG_WEP

.if ${MK_WPA_SUPPLICANT_EAPOL} != "no"
CFLAGS+=-DCONFIG_HS20 \
	-DEAP_GTC \
	-DEAP_LEAP \
	-DEAP_MD5 \
	-DEAP_MSCHAPv2 \
	-DEAP_OTP \
	-DEAP_PEAP \
	-DEAP_PSK \
	-DEAP_TLS \
	-DEAP_TTLS \
	-DEAP_WSC \
	-DIEEE8021X_EAPOL \
	-DCONFIG_INTERWORKING \
	-DCONFIG_WPS \
	-DCONFIG_WPS2 \
	-DCONFIG_WPS_UPNP \
	-DCONFIG_WPS_OOB
NEED_AES_EAX=y
NEED_AES_ENCBLOCK=y
NEED_AES_OMAC1=y
.endif

.if ${MK_OPENSSL} != "no"
CFLAGS+=-DCONFIG_PASN
.endif

.if !empty(CFLAGS:M*-DEAP_AKA)
NEED_SIM_COMMON=y
NEED_AES_CBC=y
.endif

.if !empty(CFLAGS:M*-DEAP_SIM)
NEED_SIM_COMMON=y
NEED_AES_CBC=y
.endif

.if defined(NEED_SIM_COMMON)
NEED_FIPS186_2_PRF=y
.endif

.if !empty(CFLAGS:M*-DEAP_GPSK)
CFLAGS+=-DEAP_GPSK_SHA256
NEED_AES_OMAC1=y
.endif
